// Lemmings - Windows CE port by Jacco Bikker, a.k.a.
// "The Phantom"  -   Intended as a demonstration of
//   EasyCE - Visit http://www.cewarez.com/coding
// --------------------------------------------------
#include "easyce.h"
#include "lemmings.h"

#define FLAKES 400 // Number of snowflakes in level 1

// Statics (hey, who cares:)
unsigned short* LAnim::s_Frames = 0; // Ptr to anim image data
LAnim* walkleft, *walkright, *fallleft, *fallright, *stopper;
LAnim* bridgeleft, *bridgeright, *bomber, *digger, *axeman;
LAnim* floatleft, *floatright, *bashleft, *bashright;
LAnim* digleft, *digright, *climbleft, *climbright;
LAnim* edgeleft, *edgeright, *countdown, *dropdead;
LAnim* waitleft, *waitright, *goingin; // Available anims
unsigned short* p = 0; // Framebuffer pointer
unsigned short* f = 0; // Anim image data
unsigned short* t = 0; // Temporary image buffer
unsigned short* b1 = 0, *b2 = 0; // Button image data
int command = 0; // Selected command
int lactive = 0; // Number of lemmings active
int startx = 100, starty = 100; // Default spawn pos of lemmings
bool water; // Show cool water in last 33 scanlines
bool snow; // Cool snow effect
bool paused = false; // Game is not paused
bool confirm = false; // Confirmation for armageddon required
bool armageddon = false; // Armageddon activation
int framenr; // Frame counter; used for water
int rate; // Rate at wich new lemmings are generated
int lmax; // Total number of lemmings
int snupd; // Snow update;
int ex1, ey1, ex2, ey2; // Coordinates of exit port
int comcount[11]; // Available commands
int snx[FLAKES], sny[FLAKES]; // Snow flake coordinates

// --------------------------------------------------
// Val: 'Intensity' of a 16bit color value
// Used for the simple collision detection
// --------------------------------------------------
int val( int n )
{
	int v1 = (n & (31 << 11)) >> 11;
	int v2 = (n & (63 << 5)) >> 6;
	int v3 = n & 31;
	return (v1 + v2 + v3) * 3;
}

// --------------------------------------------------
// Lemming constructor
// --------------------------------------------------
Lemming::Lemming()
{
	// Set current animation for this lemming
	m_Anim = 0;
	// Set the frame nr for the animation
	m_Frame = 0;
	// Not a climber, not a bomb, not a floater yet
	m_Floater = m_Climber = m_Bomb = false;
}

// --------------------------------------------------
// Lemming destructor
// --------------------------------------------------
Lemming::~Lemming()
{
	// Nothing to destory
}

// --------------------------------------------------
// Update a lemming
// Actual action depends on current animation
// --------------------------------------------------
void Lemming::update()
{
	if (!m_Anim) return;
	unsigned short* buff = p + m_X + 5 + m_Y * 240;
	unsigned short* wrt = t + m_X + 5 + m_Y * 240;
	if (m_Anim == walkleft)
	{
		// Lemming is walking to the left
		m_X -= 1;
		buff -= 1;
		if (val(*(buff + 9 * 240)) > 40) 
		{
			m_Y--;
			if (val(*(buff + 8 * 240)) > 40) 
			{
				m_Y--;
				if (val(*(buff + 7 * 240)) > 40) 
				{
					m_Y--;
					if (val(*(buff + 6 * 240)) > 40) 
					{
						if (m_Climber)
						{
							m_Y += 3;
							m_X += 2;
							m_Anim = climbleft;
						}
						else
						{
							m_Anim = walkright;
							m_Y += 3;
						}
					}
				}
			}
		}
		else if (val(*(buff + 10 * 240)) < 40) 
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40)
			{
				m_Y++;
				if (val(*(buff + 12 * 240)) < 40) 
				{
					m_Y++;
					if (val(*(buff + 12 * 240)) < 40) 
					{
						if (m_Floater) 
						{
							m_Y -= 6;
							m_Anim = floatleft; 
							m_Frame = 0;
						}
						else 
						{
							m_Anim = fallleft;
							m_Height = m_Y;
						}
					}
				}
			}
		}
	}
	else if (m_Anim == walkright)
	{
		// Walking to the right
		m_X += 1;
		buff += 1;
		if (val(*(buff + 9 * 240)) > 40) 
		{
			m_Y--;
			if (val(*(buff + 8 * 240)) > 40) 
			{
				m_Y--;
				if (val(*(buff + 7 * 240)) > 40) 
				{
					m_Y--;
					if (val(*(buff + 6 * 240)) > 40) 
					{
						if (m_Climber)
						{
							m_Y += 3;
							m_X -= 2;
							m_Anim = climbright;
						}
						else
						{
							m_Anim = walkleft;
							m_Y += 3;
						}
					}
				}
			}
		}
		else if (val(*(buff + 10 * 240)) < 40) 
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40) 
			{
				m_Y++;
				if (val(*(buff + 12 * 240)) < 40) 
				{
					m_Y++;
					if (val(*(buff + 13 * 240)) < 40)
					{ 
						if (m_Floater) 
						{
							m_Anim = floatright;
							m_Frame = 0;
							m_Y -= 6;
						}
						else 
						{
							m_Anim = fallright;
							m_Height = m_Y;
						}
					}
				}
			}
		}
	}
	else if (m_Anim == floatleft )
	{
		// Floating and looking left
		if (val(*(buff + 16 * 240)) < 40) m_Y++; else
		{
			m_Anim = walkleft;
			m_Y += 6;
		}
	}
	else if (m_Anim == fallleft )
	{
		// Falling and looking left
		bool hitground = false;
		if (m_Floater) m_Anim = floatleft;
		if (val(*(buff + 10 * 240)) < 40)
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40)
			{
				m_Y++;
				if (val(*(buff + 12 * 240)) < 40) m_Y++; else hitground = true;
			}
			else hitground = true;
		}
		else hitground = true;
		if (hitground)
		{
			if ((m_Y - m_Height) < 40) m_Anim = walkleft;
								  else m_Anim = dropdead;
		}
	}
	else if (m_Anim == floatright )
	{
		// Floating and looking right
		if (val(*(buff + 16 * 240)) < 40) m_Y++;	else
		{
			m_Anim = walkright;
			m_Y += 6;
		}
	}
	else if (m_Anim == fallright )
	{
		// Falling and looking right
		bool hitground = false;
		if (m_Floater) m_Anim = floatright;
		if (val(*(buff + 10 * 240)) < 40)
		{
			m_Y++;
			if (val(*(buff + 11 * 240)) < 40)
			{
				m_Y++;
				if (val(*(buff + 12 * 240)) < 40) m_Y++; else hitground = true;
			}
			else hitground = true;
		}
		else hitground = true;
		if (hitground)
		{
			if ((m_Y - m_Height) < 40) m_Anim = walkright;
								  else m_Anim = dropdead;
		}
	}
	else if (m_Anim == stopper)
	{
		// Blocking other lemmings
		// Do nothing special
	}
	else if (m_Anim == bridgeleft)
	{	
		// Building a bridge to the left
		if ((m_Frame == 9) && (m_Counter < 4))
			 play( L"\\Program Files\\EasyCE\\sounds\\ting.wav" );
		if (m_Frame == 15)
		{
			if (--m_Counter > 0)
			{
				*(wrt + 12 * 240 - 2) = 65535;
				*(wrt + 12 * 240 - 1) = 65535;
				*(wrt + 12 * 240) = 65535;
				m_X -= 2;
				m_Y -= 1;
				if (val(*(buff + 12 * 240 - 1)) > 40) 
				{
					m_Anim = walkright;
					m_Y += 3;
				}
			}
			else 
			{
				m_Anim = waitleft;
				m_Frame = 0;
			}
		}
	}
	else if (m_Anim == bridgeright)
	{
		// Building a bridge to the right
		if ((m_Frame == 9) && (m_Counter < 4))
			 play( L"\\Program Files\\EasyCE\\sounds\\ting.wav" );
		if (m_Frame == 15)
		{
			if (--m_Counter > 0)
			{
				*(wrt + 12 * 240 + 2) = 65535;
				*(wrt + 12 * 240 + 3) = 65535;
				*(wrt + 12 * 240 + 4) = 65535;
				m_X += 2;
				m_Y -= 1;
				if (val(*(buff + 12 * 240 + 3)) > 40) 
				{
					m_Anim = walkleft;
					m_Y += 3;
				}
			}
			else 
			{
				m_Anim = waitright;
				m_Frame = 0;
			}
		}
	}
	else if (m_Anim == bomber)
	{
		// Bomb going off
		if (m_Frame == 1) play( L"\\Program Files\\EasyCE\\sounds\\ohno.wav" );
		if (m_Frame == 15)
		{
			play( L"\\Program Files\\EasyCE\\sounds\\explode.wav" );
			for ( int sy = 0; sy < 23; sy++ )
			{
				unsigned short* src = f + 133 + ((1 + sy) << 8);
				for ( int sx = 0; sx < 17; sx++ )
					if (*(src + sx) != 0) *(wrt - 8 + sx + (sy - 4) * 240) = 0;
			}
		}
		if (m_Frame == 31) 
		{
			m_Anim = 0;
			lactive--;
		}
	}
	else if (m_Anim == digger)
	{
		// Digging straight down
		if (m_Frame == 15)
		{
			for ( int i = 0; i < 9; i++ )
			{
				*(wrt + 12 * 240 - 4 + i) = 0;
				*(wrt + 12 * 240 + 236 + i) = 0;
			}
			for ( i = 0; i < 7; i++ ) *(wrt + 12 * 240 + 477 + i) = 0;
			m_Y += 2;
			if (val(*(buff + 14 * 240)) < 40) 
			{
				m_Anim = walkleft;
				m_Y -= 4;
			}
		}
	}
	else if (m_Anim == bashleft)
	{
		// Bashing to the left
		if ((m_Frame > 9) && (m_Frame < 14)) m_X--;
		if ((m_Frame > 25) && (m_Frame < 30)) m_X--;
		bool ready = true;
		for ( int sy = 0; sy < 10; sy++ )
		{
			if (*(buff - 4 + sy * 240) > 40)
			{
				ready = false;
				break;
			}
		}
		if (ready) m_Anim = walkleft;
		for ( sy = 0; sy < 10; sy++ )
		{
			unsigned short* src = f + 177 + (sy << 8);
			for ( int sx = 0; sx < 10; sx++ )
				if (*(src + sx) != 0) *(wrt - 4 + sx + sy * 240) = 0;
		}
	}
	else if (m_Anim == bashright)
	{
		// Bashing to the right
		if ((m_Frame > 9) && (m_Frame < 14)) m_X++;
		if ((m_Frame > 25) && (m_Frame < 30)) m_X++;
		bool ready = true;
		for ( int sy = 0; sy < 10; sy++ )
		{
			if (val(*(buff + 8 + sy * 240)) > 40)
			{
				ready = false;
				break;
			}
		}
		if (ready) m_Anim = walkright;
		for ( sy = 0; sy < 10; sy++ )
		{
			unsigned short* src = f + 163 + (sy << 8);
			for ( int sx = 0; sx < 10; sx++ )
				if (*(src + sx) != 0) *(wrt + 2 + sx + sy * 240) = 0;
		}
	}
	else if (m_Anim == digleft)
	{
		// Pick axe (not working)
		if (m_Frame == 16) 
		{
			m_Y++;
			m_X -= 2;
		}
	}
	else if (m_Anim == digright)
	{
		// Pick axe (not working)
		if (m_Frame == 16)
		{
			m_Y++;
			m_X += 2;
		}
	}
	else if (m_Anim == climbleft)
	{
		// Climbing while looking left
		if (m_Frame > 4) m_Y--;
		if ((m_Frame < 5) && (val(*(buff + (4 - m_Frame) * 240 - 2)) < 40)) 
		{
			m_Anim = edgeleft;
			m_Y -= (m_Frame + 4);
			m_Frame = 0;
		}
		if (val(*(buff + 2 * 240 - 1)) > 40) m_Anim = fallright;
	}
	else if (m_Anim == climbright)
	{
		// Climbing while looking right
		if (m_Frame > 4) m_Y--;
		if ((m_Frame < 5) && (val(*(buff + (4 - m_Frame) * 240 + 2)) < 40)) 
		{
			m_Anim = edgeright;
			m_Y -= (m_Frame + 4);
			m_Frame = 0;
		}
		if (val(*(buff + 2 * 240 + 1)) > 40) m_Anim = fallleft;
	}
	else if (m_Anim == edgeleft)
	{
		// Finishing the left climb
		if (m_Frame == 7) 
		{
			m_Anim = walkleft;
			m_X -= 2;
		} 
	}
	else if (m_Anim == edgeright)
	{
		// Finishing the right climb
		if (m_Frame == 7) 
		{
			m_Anim = walkright;
			m_X += 2;
		}
	}
	else if (m_Anim == dropdead)
	{
		// Dying because of a high drop
		if (m_Frame == 2) play( L"\\Program Files\\EasyCE\\sounds\\splat.wav" );
		if (m_Frame == 15)
		{
			m_Anim = 0;
			lactive--;
		}
	}
	else if (m_Anim == waitleft)
	{
		// Left bridge is ready, what next
		if (m_Frame == 11)
		{
			m_Anim = walkleft;
			m_Y += 3;
			m_Frame = 0;
		}
	}
	else if (m_Anim == waitright)
	{
		// Right bridge is ready, what next
		if (m_Frame == 11)
		{
			m_Anim = walkright;
			m_Y += 3;
			m_Frame = 0;
		}
	}
	else if (m_Anim == goingin)
	{
		// Home
		if (m_Frame == 2) play( L"\\Program Files\\EasyCE\\sounds\\oing.wav" );
		if (m_Frame == 7)
		{
			m_Anim = 0;
			lactive--;
		}
	}
	if ((m_X >= ex1) && (m_X <= ex2) && (m_Y >= ey1) && (m_Y <= ey2))
	{
		m_Anim = goingin;
		m_Y -= 3;
		m_Frame = 0;
	}
	if (m_Y > 233) // Punish them for walking on the menu
	{
		m_Anim = dropdead;
		m_Frame = 0;
	}
}

// --------------------------------------------------
// Draw a lemming
// Update the frame number, and add a counter if 
// this is a bomb. Actual drawing is performed
// by the animation class
// --------------------------------------------------
void Lemming::draw( void )
{
	if (m_Anim) 
	{
		m_Frame++;
		if (m_Frame >= m_Anim->getframes()) 
		{
			if ((m_Anim == floatleft) || (m_Anim == floatright)) m_Frame = 4; else m_Frame = 0;
		}
		m_Anim->update( m_X, m_Y, m_Frame );
	}
	if ((m_Bomb) && (m_Anim))
	{
		int bc = --m_BCount / 8;
		if (bc == 0)
		{
			m_Anim = bomber;
			m_Bomb = false;
			m_Frame = 0;
		}
		else
		{
			countdown->update( m_X + 3, m_Y - 6, bc - 1 );
		}
	}
}

// --------------------------------------------------
// Animation constructor
// --------------------------------------------------
LAnim::LAnim()
{
	m_Frames = 0;
}

// --------------------------------------------------
// Animation destructor
// --------------------------------------------------
LAnim::~LAnim()
{
	// Nothing to destroy
}

// --------------------------------------------------
// Draw the animation in the frame buffer
// --------------------------------------------------
void LAnim::update( int x, int y, int frame )
{
	unsigned short* src = s_Frames + m_Fx[frame] + (m_Fy[frame] << 8);
	unsigned short* dst = p + x + y * 240;
	for ( int v = 0; v < m_Fszy; v++ )
	{
		for ( int h = 0; h < m_Fszx; h++ )
		{
			unsigned short pixel = *(src + h);
			if (pixel > 0) *(dst + h) = pixel;
		}
		src += 256;
		dst += 240;
	}
}

// --------------------------------------------------
// Initialize the anims
// --------------------------------------------------
void initanims()
{
	LAnim::s_Frames = f;
	walkright = new LAnim();
	walkright->setframes( 8 );
	walkright->setsize( 10, 10 );
	for ( int i = 0; i < 8; i++ ) walkright->setfpos( i, i * 16, 0 );
	walkleft = new LAnim();
	walkleft->setframes( 8 );
	walkleft->setsize( 10, 10 );
	for ( i = 0; i < 8; i++ ) walkleft->setfpos( i, (7 - i) * 16, 10 );
	fallright = new LAnim();
	fallright->setframes( 4 );
	fallright->setsize( 10, 10 );
	for ( i = 0; i < 8; i++ ) fallright->setfpos( i, i * 16, 10 );
	fallleft = new LAnim();
	fallleft->setframes( 4 );
	fallleft->setsize( 10, 10 );
	for ( i = 0; i < 8; i++ ) fallleft->setfpos( i, i * 16, 10 );
	stopper = new LAnim();
	stopper->setframes( 16 );
	stopper->setsize( 12, 10 );
	for ( i = 0; i < 16; i++ ) stopper->setfpos( i, i * 16, 148 );
	bridgeleft = new LAnim();
	bridgeleft->setframes( 16 );
	bridgeleft->setsize( 16, 13 );
	for ( i = 0; i < 16; i++ ) bridgeleft->setfpos( i, i * 16, 208 );
	bridgeright = new LAnim();
	bridgeright->setframes( 16 );
	bridgeright->setsize( 16, 13 );
	for ( i = 0; i < 16; i++ ) bridgeright->setfpos( i, i * 16, 195 );
	bomber = new LAnim();
	bomber->setframes( 32 );
	bomber->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) bomber->setfpos( i, i * 16, 128 );
	for ( i = 0; i < 16; i++ ) bomber->setfpos( i + 16, i * 16, 138 );
	floatleft = new LAnim();
	floatleft->setframes( 12 );
	floatleft->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) floatleft->setfpos( i, i * 16, 112 );
	for ( i = 0; i < 4; i++ ) floatleft->setfpos( i + 8, (7 - i) * 16, 112 );
	floatright = new LAnim();
	floatright->setframes( 12 );
	floatright->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) floatright->setfpos( i, i * 16, 96 );
	for ( i = 0; i < 4; i++ ) floatright->setfpos( i + 8, (7 - i) * 16, 96 );
	digger = new LAnim();
	digger->setframes( 16 );
	digger->setsize( 16, 14 );
	for ( i = 0; i < 16; i++ ) digger->setfpos( i, i * 16, 247 );
	bashleft = new LAnim();
	bashleft->setframes( 32 );
	bashleft->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) bashleft->setfpos( i, i * 16, 281 );
	for ( i = 0; i < 16; i++ ) bashleft->setfpos( i + 16, i * 16, 291 );
	bashright = new LAnim();
	bashright->setframes( 32 );
	bashright->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) bashright->setfpos( i, i * 16, 261 );
	for ( i = 0; i < 16; i++ ) bashright->setfpos( i + 16, i * 16, 271 );
	digleft = new LAnim();
	digleft->setframes( 24 );
	digleft->setsize( 16, 13 );
	for ( i = 0; i < 12; i++ ) digleft->setfpos( i, i * 16, 327 );
	for ( i = 0; i < 12; i++ ) digleft->setfpos( i + 12, i * 16, 340 );
	digright = new LAnim();
	digright->setframes( 24 );
	digright->setsize( 16, 13 );
	for ( i = 0; i < 12; i++ ) digright->setfpos( i, i * 16, 301 );
	for ( i = 0; i < 12; i++ ) digright->setfpos( i + 12, i * 16, 314 );
	climbleft = new LAnim();
	climbleft->setframes( 8 );
	climbleft->setsize( 16, 11 );
	for ( i = 0; i < 8; i++ ) climbleft->setfpos( i, i * 16, 53 );
	climbright = new LAnim();
	climbright->setframes( 8 );
	climbright->setsize( 16, 11 );
	for ( i = 0; i < 8; i++ ) climbright->setfpos( i, i * 16, 41 );
	edgeleft = new LAnim();
	edgeleft->setframes( 8 );
	edgeleft->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) edgeleft->setfpos( i, i * 16, 80 );
	edgeright = new LAnim();
	edgeright->setframes( 8 );
	edgeright->setsize( 16, 16 );
	for ( i = 0; i < 8; i++ ) edgeright->setfpos( i, i * 16, 64 );
	countdown = new LAnim();
	countdown->setframes( 5 );
	countdown->setsize( 5, 5 );
	for ( i = 0; i < 5; i++ ) countdown->setfpos( i, i * 16 + 135, 116 );
	dropdead = new LAnim();
	dropdead->setframes( 16 );
	dropdead->setsize( 16, 10 );
	for ( i = 0; i < 16; i++ ) dropdead->setfpos( i, i * 16, 138 );
	waitleft = new LAnim();
	waitleft->setframes( 12 );
	waitleft->setsize( 16, 13 );
	for ( i = 0; i < 8; i++ ) waitleft->setfpos( i, i * 16, 234 );
	for ( i = 8; i < 12; i++ ) waitleft->setfpos( i, 7 * 16, 234 );
	waitright = new LAnim();
	waitright->setframes( 12 );
	waitright->setsize( 16, 13 );
	for ( i = 0; i < 8; i++ ) waitright->setfpos( i, i * 16, 221 );
	for ( i = 8; i < 12; i++ ) waitright->setfpos( i, 7 * 16, 221 );
	goingin = new LAnim();
	goingin->setframes( 8 );
	goingin->setsize( 16, 13 );
	for ( i = 0; i < 8; i++ ) goingin->setfpos( i, i * 16, 182 );
}

// --------------------------------------------------
// Initialize a level
// --------------------------------------------------
void initlevel( unsigned short* f, char* d, bool s, bool w, int r, int l )
{
	clear( 0 );
	centre( d, 150, 65535 );
	update();
	resettimer();
	while (msecs() < 2000) {};
	clear( 0 );
	update();
	resettimer();
	while (msecs() < 500) {};
	loadtga( f, 240, 240, p, true );
	ex1 = 190; ey1 = 74;
	ex2 = 198; ey2 = 90;
	startx = 69; starty = 57;
	rate = r;
	snow = s;
	water = w;
	lmax = l;
}

// --------------------------------------------------
// Show the buffer rotated
// --------------------------------------------------
void scale( int size, int lines )
{
	int x1 = 1024 * ((240 - size) / 2);
	int y1 = 1024 * ((240 - size) / 2);
	int delta = (size * 1024) / 240;
	unsigned short* dst = p;
	for ( int y = 0; y < lines; y++ )
	{
		int x2 = x1;
		for ( int x = 0; x < 240; x++ )
		{
			*dst++ = *(t + (x2 >> 10) + (y1 >> 10) * 240);
			x2 += delta;
		}
		y1 += delta;
	}
}

// --------------------------------------------------
// Title screen with level select
// --------------------------------------------------
bool title()
{
	loadtga( L"Program Files\\EasyCE\\title_pal.tga", 240, 320, t, true );
	resettimer();
	while (msecs() < 800)
	{
		int r = (msecs() * 230) / 800;
		scale( 10 + r, 320 );
		update();
	}
	memcpy( p, t, 320 * 480 );
	while (1)
	{
		if (clicked())
		{
			int x = clickxpos();
			int y = clickypos();
			// if ((x > 160) && (y < 20) && (x < 215)) options();
			if ((x > 180) && (y > 270)) 
			{
				resettimer();
				while (msecs() < 800)
				{
					int r = (msecs() * 230) / 800;
					scale( 240 - r, 320 );
					update();
				}
				clear( *(p + 50 + 50 * 240) );
				update();
				return false;
			}
			if ((x < 20) && (y > 293)) snapshot();
			if ((x > 97) && (x < 216))
			{
				if ((y > 35) && (y < 62))
				{
					initlevel ( L"Program Files\\EasyCE\\level4.tga",
						"level 1 - cold as ice", true, false,
						32, 40 );
					ex1 = 77; ey1 = 202;
					ex2 = 81; ey2 = 236;
					startx = 188; starty = 17;
					comcount[1]  =  0; // Climbers
					comcount[2]  =  0; // Floaters
					comcount[3]  =  0; // Bombers
					comcount[4]  =  8; // Stoppers
					comcount[5]  =  2; // Bridgers
					comcount[6]  =  0; // Bashers
					comcount[7]  =  0; // Pickers (not working)
					comcount[10] =  2; // Diggers
					return true;
				}
				else if ((y > 71) && (y < 98))
				{
					initlevel ( L"Program Files\\EasyCE\\level1b.tga",
						"level 2 - looks easy", false, false,
						32, 40 );
					ex1 = 190; ey1 = 74;
					ex2 = 198; ey2 = 90;
					startx = 69; starty = 57;
					comcount[1]  = 2;  // Climbers
					comcount[2]  = 2;  // Floaters
					comcount[3]  = 0;  // Bombers
					comcount[4]  = 2;  // Stoppers
					comcount[5]  = 4;  // Bridgers
					comcount[6]  = 2;  // Bashers
					comcount[7]  = 0;  // Pickers (not working)
					comcount[10] = 2;  // Diggers
					return true;
				}
				else if ((y > 106) && (y < 132))
				{
					initlevel ( L"Program Files\\EasyCE\\level5.tga",
						"level 3 - tower madness", false, false,
						64, 40 );
					ex1 = 31; ey1 = 212;
					ex2 = 33; ey2 = 234;
					startx = 124; starty = 23;
					comcount[1]  =  2; // Climbers
					comcount[2]  =  2; // Floaters
					comcount[3]  =  2; // Bombers
					comcount[4]  =  0; // Stoppers
					comcount[5]  =  9; // Bridgers
					comcount[6]  =  0; // Bashers
					comcount[7]  =  0; // Pickers (not working)
					comcount[10] =  0; // Diggers
					return true;
				}
				else if ((y > 141) && (y < 168))
				{
					initlevel ( L"Program Files\\EasyCE\\level3.tga",
						"level 4 - for starters", false, true,
						22, 80 );
					ex1 = 193; ey1 = 167;
					ex2 = 197; ey2 = 194;
					startx = 34; starty = 23;
					comcount[1]  =  4; // Climbers
					comcount[2]  =  4; // Floaters
					comcount[3]  =  2; // Bombers
					comcount[4]  =  6; // Stoppers
					comcount[5]  =  2; // Bridgers
					comcount[6]  =  2; // Bashers
					comcount[7]  =  0; // Pickers (not working)
					comcount[10] =  4; // Diggers
					return true;
				}
			}
		}
		update();
	}
}

// --------------------------------------------------
// Print command counters on command buttons
// --------------------------------------------------
void printcount( int n, int x1, int y1 )
{
	bar( x1, y1, x1 + 7, y1 + 7, 0 );
	char* tmp = new char[4];
	tmp[1] = 0;
	int d1 = n % 10;
	tmp[0] = d1 + '0';
	print( tmp, x1, y1, 65535 );
}

// --------------------------------------------------
// Update command counters on command buttons
// --------------------------------------------------
void updatecounts()
{
	printcount( comcount[1], 22, 243 );
	printcount( comcount[2], 56, 243 );
	printcount( comcount[3], 91, 243 );
	printcount( comcount[4], 126, 243 );
	printcount( comcount[5], 160, 243 );
	printcount( comcount[6], 192, 243 );
	printcount( comcount[7], 226, 243 );
	printcount( comcount[10], 226, 273 );
}

// --------------------------------------------------
// Update the snow flakes
// --------------------------------------------------
void updatesnow()
{
	if (snupd == 1) snupd = 0; else snupd = 1;
	for ( int i = 0; i < FLAKES; i++ )
	{
		if ((i & 1) == snupd)
		{
			int dir = rand() & 1;
			if (i & 2)
			{
				if (dir == 0) 
				{
					snx[i]++; 
					if (snx[i] > 239) snx[i] = 0;
				}
			}
			else
			{
				if (dir == 1)
				{	
					snx[i]--;
					if (snx[i] < 1) snx[i] = 239;
				}
			}
			sny[i] += (i & 1) + 1;
			if (sny[i] > 239) sny[i] = 0;
		}
		long addr = snx[i] + sny[i] * 240;
		if ((sny[i] > 0) && (*(t + addr) > 0) && (*(t + addr - 240) == 0))
			*(t + addr) = 65535;
		*(p + addr) = 65535;
	}
}

// --------------------------------------------------
// Update the water
// --------------------------------------------------
void updatewater()
{
	unsigned short* dst = p + 207 * 240;
	for ( int y = 0; y < 33; y++ )
	{
		int val = (y + framenr) % 36;
		int line = 206 - y * 5 + (int)(y * 0.7f * sin( (float)(y + framenr) / 4 ));
		unsigned short* src = p + line * 240;
		for ( int x = 0; x < 240; x++ )
			*dst++ = (*src >> 1) & (15 + (31 << 5) + (15 << 11)) + ((*src++ >> 1) & 15);
	}
}

// --------------------------------------------------
// Main function
// --------------------------------------------------
void main()
{
	t = new unsigned short[240 * 320];
	p = (unsigned short*)getbuffer();
	f = new unsigned short[256 * 354];
	b1 = new unsigned short[240 * 80];
	b2 = new unsigned short[240 * 80];
	loadtga( L"Program Files\\EasyCE\\lemanim.tga", 256, 354, f, true );
	loadtga( L"Program Files\\EasyCE\\buttons.tga", 240, 80, b1, true );
	loadtga( L"Program Files\\EasyCE\\bbuttons.tga", 240, 80, b2, true );
	initanims();
	for ( int i = 0; i < FLAKES; i++ )
	{
		snx[i] = (rand() * 240) / RAND_MAX;
		sny[i] = i % 240;
	}
	while (1)
	{
		command = 0;
		lactive = 0;
		snow = water = false;
		paused = confirm = armageddon = false;
		if (!title()) break;
		memcpy( t, p, 240 * 240 * 2);
		memcpy( p + 240 * 240, b1, 240 * 160 );
		updatecounts();
		resettimer();
		while (msecs() < 800)
		{
			int r = (msecs() * 230) / 800;
			scale( 10 + r, 240 );
			update();
		}
		resettimer();
		memcpy( p, t, 240 * 480 );
		if (snow) updatesnow();
		if (water) updatewater();
		update();
		play( L"\\Program Files\\EasyCE\\sounds\\door.wav" );
		while (msecs() < 500) {};
		play( L"\\Program Files\\EasyCE\\sounds\\letsgo.wav" );
		Lemming* lemm[80];
		for ( int i = 0; i < 80; i++ ) lemm[i] = 0;
		int delay = 1;
		int lemmings = 0;
		int lcount = 10;
		int lout = framenr = 0;
		while (1)
		{
			if (!paused)
			{
				if (msecs() > 80)
				{
					resettimer();
					memcpy( p, t, 240 * 480 );
					for ( int i = 0; i < lemmings; i++ ) lemm[i]->update();
					for ( i = 0; i < lemmings; i++ ) lemm[i]->draw();
					if (snow) updatesnow();
					if (water) updatewater();
					update();
					framenr++;
					if ((lemmings < lmax) && (!armageddon))
					{
						if (--lcount == 0)
						{
							lemm[lemmings] = new Lemming();
							lemm[lemmings]->setpos( startx, starty );
							lemm[lemmings++]->setanim( walkleft );
							lcount = rate;
							lactive++;
							lout++;
						}
					}
				}
			} else update(); // Or else we'll miss clicks that end the pause :)
			if (armageddon && (lactive < 1)) break;
			if ((lout == 40) && (lactive == 0)) break;
			if (clicked()) 
			{
				int x = clickxpos();
				int y = clickypos();
				if ((x < 20) && (y < 20)) snapshot();
				if ((y > 240) && (y < 271))
				{
					confirm = false;
					memcpy( p + 240 * 240, b1, 480 * 80 );
					if (x < 34)
					{
						if (comcount[1] > 0) 
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h) = *(b2 + h + v * 240);
							command = 1;
						}
					}
					else if (x < 69)
					{
						if (comcount[2] > 0) 
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 34) = *(b2 + h + v * 240 + 34);
							command = 2;
						}
					}
					else if (x < 103)
					{
						if (comcount[3] > 0) 
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 69) = *(b2 + h + v * 240 + 69);
							command = 3;
						}
					}
					else if (x < 137)
					{
						if (comcount[4] > 0) 
						{
							command = 4;
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 103) = *(b2 + h + v * 240 + 103);
						}
					}
					else if (x < 171)
					{
						if (comcount[5] > 0) 
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 137) = *(b2 + h + v * 240 + 137);
							command = 5;
						}
					}
					else if (x < 206)
					{
						if (comcount[6] > 0) 
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 171) = *(b2 + h + v * 240 + 171);
							command = 6;
						}
					}
					else
					{
						if (comcount[7] > 0) 
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 240) * 240 + h + 206) = *(b2 + h + v * 240 + 206);
							command = 7;
						}
					}
					play( L"\\Program Files\\EasyCE\\sounds\\changeop.wav" );
					updatecounts();
				}
				else if ((y > 270) && (y < 300))
				{
					memcpy( p + 240 * 240, b1, 480 * 80 );
					if (x < 34)
					{
						for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
							*(p + (v + 270) * 240 + h) = *(b2 + h + (v + 30) * 240);
						command = 8;
						paused = !paused;
						confirm = false;
					}
					else if (x < 69)
					{
						if (!armageddon)
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 270) * 240 + h + 34) = *(b2 + h + (v + 30) * 240 + 34);
							if (confirm)
							{
								for ( int i = 0; i < lemmings; i++ ) if (lemm[i]->getanim()) lemm[i]->isbomb();
								armageddon = true;
							}
							else confirm = true;
						}
					}
					else if (x > 206)
					{
						if (comcount[10] > 0)
						{
							for ( int v = 0; v < 30; v++ ) for ( int h = 0; h < 34; h++ )
								*(p + (v + 270) * 240 + h + 206) = *(b2 + h + (v + 30) * 240 + 206);
							command = 10;
						}
						confirm = false;
					}
					play( L"\\Program Files\\EasyCE\\sounds\\changeop.wav" );
					updatecounts();
				}
				else 
				{
					confirm = false;
					if (command > 0)
					{
						for ( int i = 0; i < lemmings; i++ )
						{
							int lx = lemm[i]->getxpos() - 5;
							int ly = lemm[i]->getypos() - 5;
							if ((x > lx) && (x < (lx + 20)) && (y > ly) && (y < (ly + 20)))
							{
								if (command == 4)
								{
									if ((lemm[i]->getanim() == walkleft) ||
									    (lemm[i]->getanim() == walkright))
									{
										comcount[4]--;
										lemm[i]->setanim( stopper );
										unsigned short* b = t + 11 + lx + (9 + ly) * 240;
										for ( int i = 0; i < 8; i++ )
										{
											if (val(*(b + i * 240)) < 40) *(b + i * 240) = (unsigned short)(41 + (41 << 5) + (41 << 11));
											if (val(*(b + 1 + i * 240)) < 40) *(b + 1 + i * 240) = (unsigned short)(41 + (41 << 5) + (41 << 11));
										}
									}
									break;
								}
								else if (command == 5)
								{
									if ((lemm[i]->getanim() == walkleft) ||
									    (lemm[i]->getanim() == waitleft))
									{
										comcount[5]--;
										if (lemm[i]->getanim() == walkleft) lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										                               else lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos());
										lemm[i]->setanim( bridgeleft );
										lemm[i]->setframe( 0 );
										lemm[i]->setcounter( 10 );
									}
									else if ((lemm[i]->getanim() == walkright) ||
									         (lemm[i]->getanim() == waitright))
									{
										comcount[5]--;
										if (lemm[i]->getanim() == walkright) lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										                                else lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos());
										lemm[i]->setanim( bridgeright );
										lemm[i]->setframe( 0 );
										lemm[i]->setcounter( 10 );
									}
									break;
								}
								else if (command == 3)
								{
									if (!lemm[i]->getbomb())
									{
										comcount[3]--;
										lemm[i]->isbomb();
									}
									break;
								}
								else if (command == 2)
								{
									if (!lemm[i]->getfloat())
									{
										comcount[2]--;
										lemm[i]->isfloater();
									}
									break;
								}
								else if (command == 10)
								{
									if ((lemm[i]->getanim() == walkleft) ||
									    (lemm[i]->getanim() == walkright))
									{	comcount[10]--;
										lemm[i]->setanim( digger );
										lemm[i]->setframe( 0 );
										lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 2);
									}
									break;
								}
								else if (command == 6)
								{
									if (lemm[i]->getanim() == walkleft)
									{
										comcount[6]--;
										lemm[i]->setanim( bashleft );
										lemm[i]->setframe( 0 );
									}					
									else if (lemm[i]->getanim() == walkright)
									{
										comcount[6]--;
										lemm[i]->setanim( bashright );
										lemm[i]->setframe( 0 );
									}
									break;
								}
								else if (command == 7)
								{
									if (lemm[i]->getanim() == walkleft)
									{
										comcount[7]--;
										lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										lemm[i]->setanim( digleft );
										lemm[i]->setframe( 0 );
									}					
									else if (lemm[i]->getanim() == walkright)
									{
										comcount[7]--;
										lemm[i]->setpos( lemm[i]->getxpos(), lemm[i]->getypos() - 3);
										lemm[i]->setanim( digright );
										lemm[i]->setframe( 0 );
									}
									break;
								}
								else if (command == 1)
								{
									comcount[1]--;
									lemm[i]->isclimber();
									break;
								}
							}
						}
						updatecounts();
					}
				}
			}
		}
		resettimer();
		while (msecs() < 800)
		{
			int r = (msecs() * 230) / 800;
			scale( 240 - r, 240 );
			update();
		}
		for ( i = 0; i < lemmings; i++ ) delete lemm[i];
	}
	delete t;
	delete f;
	delete walkright;
	delete walkleft;
	delete fallleft;
	delete fallright;
	delete bridgeleft;
	delete bridgeright;
	delete bomber;
	delete stopper;
	delete floatleft;
	delete floatright;
	delete digger;
	delete bashleft;
	delete bashright;
	delete digleft;
	delete digright;
	delete climbleft;
	delete climbright;
	delete edgeleft;
	delete edgeright;
	delete countdown;
	delete dropdead;
	delete waitleft;
	delete waitright;
	delete goingin;
}

// --------------------------------------------------
// EOF